/*
 * Decompiled with CFR 0.152.
 */
package com.marth7th.solidarytinker.shelf.Network.Packet;

import com.marth7th.solidarytinker.client.Renderer.Halo.HaloClientCache;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public class HaloUpdatePacket {
    private final UUID playerUUID;
    private final Map<ModifierId, Boolean> haloStates;

    public HaloUpdatePacket(UUID playerUUID, Map<ModifierId, Boolean> haloStates) {
        this.playerUUID = playerUUID;
        this.haloStates = haloStates;
    }

    public HaloUpdatePacket(FriendlyByteBuf buf) {
        this.playerUUID = buf.m_130259_();
        int size = buf.m_130242_();
        this.haloStates = new ConcurrentHashMap<ModifierId, Boolean>(size);
        for (int i = 0; i < size; ++i) {
            ModifierId modifierId = new ModifierId(buf.m_130281_());
            boolean isEnabled = buf.readBoolean();
            this.haloStates.put(modifierId, isEnabled);
        }
    }

    public void toByte(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerUUID);
        buf.m_130130_(this.haloStates.size());
        for (Map.Entry<ModifierId, Boolean> entry : this.haloStates.entrySet()) {
            ResourceLocation resourceLocation = new ResourceLocation(entry.getKey().m_135827_(), entry.getKey().m_135815_());
            buf.m_130085_(resourceLocation);
            buf.writeBoolean(entry.getValue().booleanValue());
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> HaloClientCache.updatePlayerHaloStates(this.playerUUID, this.haloStates));
        context.setPacketHandled(true);
    }
}

